/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.config;

import net.minecraftforge.common.ForgeConfigSpec;

public final class RodlingCommonConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Integer> hostile_exp_reward;
    public static final ForgeConfigSpec.ConfigValue<Double> hostile_fireball_damage;
    public static final ForgeConfigSpec.ConfigValue<Integer> hostile_fireball_set_mob_on_fire_length;
    public static final ForgeConfigSpec.ConfigValue<Double> hostile_max_health;
    public static final ForgeConfigSpec.ConfigValue<Double> hostile_armour;
    public static final ForgeConfigSpec.ConfigValue<Double> hostile_armour_toughness;
    public static final ForgeConfigSpec.ConfigValue<Double> hostile_movement_speed;
    public static final ForgeConfigSpec.ConfigValue<Double> hostile_follow_range;
    public static final ForgeConfigSpec.ConfigValue<Double> hostile_knockback_resistance;
    public static final ForgeConfigSpec.ConfigValue<Boolean> hostile_ignores_invulnerability_time;
    public static final ForgeConfigSpec.ConfigValue<Boolean> hostile_fireball_griefing;
    public static final ForgeConfigSpec.ConfigValue<Double> hostile_shoot_max_distance;
    public static final ForgeConfigSpec.ConfigValue<Integer> hostile_shield_regenerate_speed;
    public static final ForgeConfigSpec.ConfigValue<Boolean> hostile_attacks_players;
    public static final ForgeConfigSpec.ConfigValue<Double> hostile_following_movement_speed_multiplier;
    public static final ForgeConfigSpec.ConfigValue<Double> hostile_follow_target_wanted_distance;
    public static final ForgeConfigSpec.ConfigValue<Double> tamed_fireball_damage;
    public static final ForgeConfigSpec.ConfigValue<Integer> tamed_fireball_set_mob_on_fire_length;
    public static final ForgeConfigSpec.ConfigValue<Double> tamed_max_health;
    public static final ForgeConfigSpec.ConfigValue<Double> tamed_armour;
    public static final ForgeConfigSpec.ConfigValue<Double> tamed_armour_toughness;
    public static final ForgeConfigSpec.ConfigValue<Double> tamed_movement_speed;
    public static final ForgeConfigSpec.ConfigValue<Double> tamed_follow_range;
    public static final ForgeConfigSpec.ConfigValue<Double> tamed_knockback_resistance;
    public static final ForgeConfigSpec.ConfigValue<Boolean> tamed_ignores_invulnerability_time;
    public static final ForgeConfigSpec.ConfigValue<Integer> tamed_shield_regenerate_speed;
    public static final ForgeConfigSpec.ConfigValue<Integer> tamed_fed_heal_percent;
    public static final ForgeConfigSpec.ConfigValue<Boolean> tamed_friendly_fire;
    public static final ForgeConfigSpec.ConfigValue<Double> tamed_shoot_max_distance;
    public static final ForgeConfigSpec.ConfigValue<Double> tamed_following_movement_speed_multiplier;
    public static final ForgeConfigSpec.ConfigValue<Double> tamed_follow_target_wanted_distance;
    public static final ForgeConfigSpec.ConfigValue<Double> tamed_follow_owner_movement_speed_multiplier;
    public static final ForgeConfigSpec.ConfigValue<Double> tamed_follow_owner_start_min_distance;
    public static final ForgeConfigSpec.ConfigValue<Double> tamed_follow_owner_stop_max_distance;

    static {
        BUILDER.comment("Configure Mutant More's hostile and tamed Rodlings on the client and server sides (these changes will affect everyone in the world)! The game needs to be restarted for changes to take effect!").comment("\n \n Hostile Rodling Options").push("hostile_config");
        hostile_exp_reward = BUILDER.comment("\n The amount of Experience dropped by the hostile Rodling when it dies\n usually set to 5").define("Hostile Experience Reward", (Object)5);
        hostile_fireball_damage = BUILDER.comment("\n The damage dealt to mobs hit by the hostile Rodling's Fireballs\n usually set to 6.0").define("Hostile Fireball Damage", (Object)6.0);
        hostile_fireball_set_mob_on_fire_length = BUILDER.comment("\n The amount of time in seconds that mobs are set on fire for when hit by the hostile Rodling's Fireballs\n usually set to 5 seconds").define("Hostile Fireball Set Mobs on Fire Length", (Object)5);
        hostile_max_health = BUILDER.comment("\n The hostile Rodling's max health\n usually set to 10.0").define("Hostile Max Health", (Object)10.0);
        hostile_armour = BUILDER.comment("\n The hostile Rodling's armour value\n usually set to 0.0").define("Hostile Armour", (Object)0.0);
        hostile_armour_toughness = BUILDER.comment("\n The hostile Rodling's armour toughness value\n usually set to 0.0").define("Hostile Armour Toughness", (Object)0.0);
        hostile_movement_speed = BUILDER.comment("\n The hostile Rodling's movement speed\n usually set to 0.125").define("Hostile Movement Speed", (Object)0.125);
        hostile_follow_range = BUILDER.comment("\n The distance that hostile Rodlings can target mobs from\n usually set to 30.0").define("Hostile Follow Range", (Object)30.0);
        hostile_knockback_resistance = BUILDER.comment("\n The hostile Rodling's resistance to attack knockback\n usually set to 0.0").define("Hostile Knockback Resistance", (Object)0.0);
        hostile_ignores_invulnerability_time = BUILDER.comment("\n If the hostile Rodling's attacks ignore the brief invulnerability mobs get when damaged\n Makes sure the hostile Rodling's attacks always hit when they're supposed to\n usually set to true").define("Hostile Ignores Invulnerability Time", true);
        hostile_fireball_griefing = BUILDER.comment("\n If the hostile Rodling's fireballs set blocks they collide with on fire\n usually set to true").define("Hostile Fireball Griefing", true);
        hostile_shoot_max_distance = BUILDER.comment("\n The maximum distance from its target that the hostile Rodling can be to use its shoot attack\n usually set to 10.0").define("Hostile Shoot Maximum Distance", (Object)10.0);
        hostile_shield_regenerate_speed = BUILDER.comment("\n The amount of time in ticks (20 ticks in a second) that it takes for a shielded hostile Rodling to regenerate a broken shield\n usually set to 150 ticks (7.5 seconds)").define("Hostile Shield Regenerate Time", (Object)150);
        hostile_attacks_players = BUILDER.comment("\n If the hostile Rodling attacks players\n usually set to true").define("Hostile Attacks Players", true);
        hostile_following_movement_speed_multiplier = BUILDER.comment("\n The amount that the hostile Rodling's movement speed is multiplied when it's pursuing a target\n usually set to 1.5").define("Hostile Following Movement Speed Multiplier", (Object)1.5);
        hostile_follow_target_wanted_distance = BUILDER.comment("\n The distance to its target that the hostile Rodling tries to reach\n usually set to 7.5").define("Hostile Follow Target Wanted Distance", (Object)7.5);
        BUILDER.pop();
        BUILDER.comment("\n \n Tamed Rodling Options").push("tamed_config");
        tamed_fireball_damage = BUILDER.comment("\n The damage dealt to mobs hit by the tamed Rodling's Fireballs\n usually set to 3.0").define("Tamed Fireball Damage", (Object)3.0);
        tamed_fireball_set_mob_on_fire_length = BUILDER.comment("\n The amount of time in seconds that mobs are set on fire for when hit by the tamed Rodling's Fireballs\n usually set to 5 seconds").define("Tamed Fireball Set Mobs on Fire Length", (Object)5);
        tamed_max_health = BUILDER.comment("\n The tamed Rodling's max health\n usually set to 15.0").define("Tamed Max Health", (Object)15.0);
        tamed_armour = BUILDER.comment("\n The tamed Rodling's armour value\n usually set to 0.0").define("Tamed Armour", (Object)0.0);
        tamed_armour_toughness = BUILDER.comment("\n The tamed Rodling's armour toughness value\n usually set to 0.0").define("Tamed Armour Toughness", (Object)0.0);
        tamed_movement_speed = BUILDER.comment("\n The tamed Rodling's movement speed\n usually set to 0.125").define("Tamed Movement Speed", (Object)0.125);
        tamed_follow_range = BUILDER.comment("\n The distance that tamed Rodlings can target mobs from\n usually set to 10.0").define("Tamed Follow Range", (Object)10.0);
        tamed_knockback_resistance = BUILDER.comment("\n The tamed Rodling's resistance to attack knockback\n usually set to 0.0").define("Tamed Knockback Resistance", (Object)0.0);
        tamed_ignores_invulnerability_time = BUILDER.comment("\n If the tamed Rodling's attacks ignore the brief invulnerability mobs get when damaged\n Makes sure the tamed Rodling's attacks always hit when they're supposed to\n usually set to true").define("Tamed Ignores Invulnerability Time", true);
        tamed_shield_regenerate_speed = BUILDER.comment("\n The amount of time in ticks (20 ticks in a second) that it takes for a shielded tamed Rodling to regenerate a broken shield\n usually set to 150 ticks (7.5 seconds)").define("Tamed Shield Regenerate Time", (Object)150);
        tamed_fed_heal_percent = BUILDER.comment("\n The percent of max health that the tamed Rodling is healed when fed with a valid item\n usually set to 20%").define("Tamed Fed Heal Percent", (Object)20);
        tamed_friendly_fire = BUILDER.comment("\n If tamed Rodlings can harm their owner and mobs allied to their owner (mainly other pets)\n usually set to false").define("Tamed Friendly Fire", false);
        tamed_shoot_max_distance = BUILDER.comment("\n The maximum distance from its target that the tamed Rodling can be to use its shoot attack\n usually set to 10.0").define("Tamed Shoot Maximum Distance", (Object)10.0);
        tamed_following_movement_speed_multiplier = BUILDER.comment("\n The amount that the tamed Rodling's movement speed is multiplied when it's pursuing a target\n usually set to 1.5").define("Tamed Following Movement Speed Multiplier", (Object)1.5);
        tamed_follow_target_wanted_distance = BUILDER.comment("\n The distance to its target that the tamed Rodling tries to reach\n usually set to 7.5").define("Tamed Follow Target Wanted Distance", (Object)7.5);
        tamed_follow_owner_movement_speed_multiplier = BUILDER.comment("\n The amount that the tamed Rodling's movement speed is multiplied when it's following its owner\n usually set to 1.5").define("Tamed Follow Owner Movement Speed Multiplier", (Object)1.5);
        tamed_follow_owner_start_min_distance = BUILDER.comment("\n The minimum distance from its owner that the tamed Rodling has to be to start following them\n usually set to 7.5").define("Tamed Follow Owner Start Minimum Distance", (Object)7.5);
        tamed_follow_owner_stop_max_distance = BUILDER.comment("\n The maximum distance from its owner that the tamed Rodling can be to stop following them\n usually set to 5.0").define("Tamed Follow Owner Stop Maximum Distance", (Object)5.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

